package ru.yandex.featurer.data

import java.time.ZonedDateTime

import ru.yandex.autodoc.spray.common.res.Json

/**
 * @author avhaliullin
 */
case class ApplicationFeatureInfo(featureId: FeatureId, artifactDate: Option[ZonedDateTime])

object ApplicationFeatureInfo extends ((FeatureId, Option[ZonedDateTime]) => ApplicationFeatureInfo) {
  implicit val renderer = Json.Object[ApplicationFeatureInfo](
    "featureId" -> Json.field(_.featureId.id),
    "artifactBuildDate" -> Json.field(_.artifactDate.map(_.toString))
  )
}