package ru.yandex.featurer.data

import ru.yandex.autodoc.spray.common.res.Json

/**
 * @author avhaliullin
 */
case class ApplicationInfo(appId: AppId, teamcityBuildId: TeamcityBuildId, port: Int, service: UbicService,
                           baseContainerName: String)

object ApplicationInfo extends ((AppId, TeamcityBuildId, Int, UbicService, String) => ApplicationInfo) {
  implicit val renderer = Json.Object[ApplicationInfo](
    "appId" -> Json.field(_.appId.id),
    "teamcityBuildId" -> Json.field(_.teamcityBuildId.id),
    "port" -> Json.field(_.port),
    "baseContainerName" -> Json.field(_.baseContainerName)
  )
}
