package ru.yandex.featurer.data

import java.time.ZonedDateTime

import ru.yandex.autodoc.spray.common.res.Json
import spray.http.Uri

/**
 * @author avhaliullin
 */
case class TeamcityArtifactInfo(appId: AppId, featureId: FeatureId, downloadUrl: Uri, modifiedDate: ZonedDateTime, fileName: String)

object TeamcityArtifactInfo {
  implicit val renderer = Json.Object[TeamcityArtifactInfo](
    "downloadUrl" -> Json.field(_.downloadUrl),
    "fileName" -> Json.field(_.fileName),
    "modifiedDate" -> Json.field(_.modifiedDate.toString)
  )
}
