package ru.yandex.featurer

import ru.yandex.featurer.utils.SprayJsonUtils

/**
 * @author avhaliullin
 */
package object data {

  case class FeatureId(id: String)

  case class AppId(id: String)

  case class TeamcityBuildId(id: String)

  type ContainerStateEnum = ContainerStateEnum.Value

  import spray.json.DefaultJsonProtocol._
  implicit val featureIdFormat = SprayJsonUtils.delegate[FeatureId, String](_.id, FeatureId)
  implicit val appIdFormat = SprayJsonUtils.delegate[AppId, String](_.id, AppId)
  implicit val teamcityBuildIdFormat = SprayJsonUtils.delegate[TeamcityBuildId, String](_.id, TeamcityBuildId)
}
