package ru.yandex.featurer.error

/**
 * @author avhaliullin
 */
class UserException(val message: String) extends Exception(message)

object UserException {

  case class ResourceNotFound(kind: String, id: String) extends UserException(s"Resource ($kind) with id '$id' not found")

  case class IllegalState(msg: String) extends UserException("Illegal state: " + msg)

}
