package ru.yandex.featurer.utils

import org.slf4j.Logger
import spray.routing.Directive0
import spray.routing.directives.BasicDirectives._

/**
 * @author avhaliullin
 */
object CustomDirectives {
  def logRequest(log: Logger): Directive0 = mapRequestContext {
    ctx =>
      val now = System.currentTimeMillis()
      val reqId = System.identityHashCode(ctx.request)
      log.info(s"Start processing request $reqId\n${ctx.request.uri}")
      ctx.withRouteResponseMapped {
        res =>
          log.info(s"Request $reqId processed in ${System.currentTimeMillis() - now} ms")
          res
      }
  }
}