package ru.yandex.featurer.utils

import spray.json.{JsValue, JsonFormat}

/**
 * @author avhaliullin
 */
object SprayJsonUtils {
  def delegate[A, B: JsonFormat](a2b: A => B, b2a: B => A): JsonFormat[A] = new JsonFormat[A] {
    private val delegate = implicitly[JsonFormat[B]]

    def read(json: JsValue): A = b2a(delegate.read(json))

    def write(obj: A): JsValue = delegate.write(a2b(obj))
  }

}
