package ru.yandex.featurer.utils.config

import java.io.File

import com.typesafe.config.{ConfigFactory, ConfigIncludeContext, ConfigIncluderFile, ConfigObject}

/**
 * @author avhaliullin
 */
class ConfDirAwareFileIncluder(configDir: File) extends ConfigIncluderFile {
  private def doInclude(context: ConfigIncludeContext, file: File) = {
    ConfigFactory.parseFileAnySyntax(file, context.parseOptions).root
  }

  override def includeFile(context: ConfigIncludeContext, what: File): ConfigObject = {
    if (what.isAbsolute) {
      doInclude(context, what)
    } else {
      val resolved = new File(configDir.getAbsolutePath + "/" + what.getPath)
      doInclude(context, resolved)
    }
  }
}
