package ru.yandex.featurer.utils.config

import java.io.File

import com.typesafe.config._

/**
 * @author avhaliullin
 */
class EnvironmentAwareIncluder(val environment: String, val configDir: File,
                               val fallback: ConfigIncluder = ConfigParseOptions.defaults().getIncluder
                                ) extends ConfigIncluder with ConfigIncluderFile {

  lazy val kungfuConf = ConfigFactory.parseFile(new File(System.getProperty("application.startup.config.json"))).root()

  def withFallback(fallback: ConfigIncluder) = new EnvironmentAwareIncluder(environment, configDir, fallback)

  def include(context: ConfigIncludeContext, what: String) = {
    if (what == "kungfu") {
      kungfuConf
    } else {
      val regex = """^(.*)\.(json|conf|properties)$""".r

      val envConfigName = what match {
        case regex(name, extension) => s"$name.$environment.$extension"
        case name => s"$name.$environment"
      }
      val envConfig = fallback.include(context, envConfigName)

      envConfig.withFallback(fallback.include(context, what))
    }
  }

  private def doInclude(context: ConfigIncludeContext, file: File) = {
    ConfigFactory.parseFileAnySyntax(file, context.parseOptions).root
  }

  override def includeFile(context: ConfigIncludeContext, what: File): ConfigObject = {
    if (what.isAbsolute) {
      doInclude(context, what)
    } else {
      val resolved = new File(configDir.getAbsolutePath + "/" + what.getPath)
      doInclude(context, resolved)
    }
  }

}
