package ru.yandex.featurer.utils

import java.util.concurrent.TimeUnit

import com.typesafe.config.{Config, ConfigRenderOptions}

import scala.collection.JavaConversions._
import scala.concurrent.duration.{Duration, FiniteDuration}

/**
 * @author avhaliullin
 */
package object config {

  implicit class RichConfig(val config: Config) extends AnyVal {
    def getFiniteDuration(path: String): FiniteDuration = {
      Duration.fromNanos(config.getDuration(path, TimeUnit.NANOSECONDS))
    }

    def prettyPrint: String = {
      val sb = StringBuilder.newBuilder
      config.entrySet().foreach {
        kv =>
          sb.append(kv.getKey + " = " + kv.getValue.render(ConfigRenderOptions.concise()) + "\n")
      }
      sb.toString()
    }
  }

}
