#!/bin/bash

if [[ "-u" == "$1" ]]; then
    echo "Update packaging tools"
    if [[ -d "./packaging-tools" ]]; then
      pushd ./packaging-tools
      svn update
      popd
    else
      svn checkout svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/wmconsole/backend/packaging-tools
    fi
fi

_FOLDER=`pwd`
_ad="$_FOLDER/packaging-tools/bin/application_deploy.py"
_ap="$_FOLDER/packaging-tools/bin/application_package.py"
_aq="$_FOLDER/packaging-tools/bin/application_qloud.py"

if [[ ! -f "./application_deploy.sh" ]]; then
  echo "Create application_deploy.sh"
  cat > ./application_deploy.sh <<- END
#!/bin/bash
${_ad} "\$@"
END
  chmod a+x application_deploy.sh
fi

if [[ ! -f "./application_package.sh" ]]; then
    echo "Create application_package.sh"
  cat > ./application_package.sh <<- END
#!/bin/bash
${_ap} "\$@"
END
  chmod a+x application_package.sh
fi

if [[ ! -f "./application_qloud.sh" && -e "./packaging-tools/bin/application_qloud.py" ]]; then
    echo "Create application_qloud.sh"
  cat > ./application_qloud.sh <<- END
#!/bin/bash
${_aq} "\$@"
END
  chmod a+x application_qloud.sh
fi
