package ru.yandex.webmaster3.admin.action;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.data.AdminConsoleSectionEnum;
import ru.yandex.webmaster3.storage.admin.security.Role;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.security.service.AdminUsersService;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;

import java.util.EnumSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Список разделов админки, доступных текущему (авторизованному) пользователю")
public class AvailableSectionsAction extends AdminAction<AvailableSectionsRequest, AvailableSectionsResponse> {
    private AdminUsersService adminUsersService;

    public AvailableSectionsAction() {
        super(null);
    }

    @Override
    public AvailableSectionsResponse process(AvailableSectionsRequest request) throws WebmasterException {
        Set<Role> roles = adminUsersService.listUserRoles(request.getAdminUserId());
        EnumSet<AdminConsoleSectionEnum> result = EnumSet.noneOf(AdminConsoleSectionEnum.class);
        for (Role role : roles) {
            for (AdminConsoleSectionEnum sectionEnum : AdminConsoleSectionEnum.values()) {
                if (role.getPermissions().contains(sectionEnum.getRelatedPermission())) {
                    result.add(sectionEnum);
                }
            }
        }
        return new AvailableSectionsResponse(result);
    }

    @Required
    public void setAdminUsersService(AdminUsersService adminUsersService) {
        this.adminUsersService = adminUsersService;
    }
}
