package ru.yandex.webmaster3.admin.action;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.service.AdminUsersHostsService;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;

/**
 * @author avhaliullin
 */
@WriteAction
@Description("Подтвердить себе права на сайт")
public class CreateSelfVerificationAction extends AdminAction<CreateSelfVerificationRequest, CreateSelfVerificationResponse> {
    private AdminUsersHostsService adminUsersHostsService;

    public CreateSelfVerificationAction() {
        super(AccessObjectEnum.HOST_SELF_VERIFICATION);
    }

    @Override
    public CreateSelfVerificationResponse process(CreateSelfVerificationRequest request) throws WebmasterException {
        adminUsersHostsService.createSelfVerification(
                request.getAdminUserId(),
                request.getHostId()
        );
        return new CreateSelfVerificationResponse();
    }

    @Required
    public void setAdminUsersHostsService(AdminUsersHostsService adminUsersHostsService) {
        this.adminUsersHostsService = adminUsersHostsService;
    }

}
