package ru.yandex.webmaster3.admin.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AdminUserIdAware;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * @author avhaliullin
 */
public class CreateSelfVerificationRequest extends AbstractFrontendRequest implements AdminUserIdAware {
    private long adminUserId;
    private WebmasterHostId hostId;

    @Override
    public long getAdminUserId() {
        return adminUserId;
    }

    @Override
    public void setAdminUserId(long userId) {
        this.adminUserId = userId;
    }

    @Description("хост, на который подтверждаем права")
    @RequestQueryProperty(required = true)
    public void setHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

}
