package ru.yandex.webmaster3.admin.action;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.data.SimpleHostInfoView;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.core.blackbox.UserWithLogin;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.security.service.AdminUsersService;
import ru.yandex.webmaster3.core.blackbox.service.BlackboxUsersService;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Пользователи, подтвердившие/добавившие хост")
@Component("/admin/host/listUsers")
public class ListUsersForHostAction extends AdminAction<ListUsersForHostRequest, ListUsersForHostResponse> {
    private final UserHostsService userHostsService;
    private final AdminUsersService adminUsersService;
    private final BlackboxUsersService blackboxExternalYandexUsersService;

    @Autowired
    public ListUsersForHostAction(UserHostsService userHostsService,
                                  AdminUsersService adminUsersService,
                                  BlackboxUsersService blackboxExternalYandexUsersService) {
        super(AccessObjectEnum.USERS_HOSTS);
        this.userHostsService = userHostsService;
        this.adminUsersService = adminUsersService;
        this.blackboxExternalYandexUsersService = blackboxExternalYandexUsersService;
    }

    private String getLogin(long userId) {
        UserWithLogin userWithLogin = blackboxExternalYandexUsersService.getUserById(userId);
        return userWithLogin == null ? null : userWithLogin.getLogin();
    }

    @Override
    public ListUsersForHostResponse process(ListUsersForHostRequest request) throws WebmasterException {
        WebmasterHostId hostId = IdUtils.urlToHostId(request.getHostUrl());

        Map<Long, UserVerifiedHost> verified = userHostsService.listUsersVerifiedHost(hostId);
        List<ListUsersForHostResponse.HostUserInfo> hostUserInfos = new ArrayList<>();
        for (Map.Entry<Long, UserVerifiedHost> entry : verified.entrySet()) {
            hostUserInfos.add(new ListUsersForHostResponse.HostUserInfo(entry.getKey(), getLogin(entry.getKey()),
                    entry.getValue().getVerificationDate(), true));
        }
        long externalUid = adminUsersService.getAssociatedExternalUserId(request.getAdminUserId());
        boolean verifiedForMe = userHostsService.getVerifiedHost(new WebmasterUser(externalUid), hostId) != null;

        return new ListUsersForHostResponse(new SimpleHostInfoView(hostId), verifiedForMe, hostUserInfos);
    }
}
