package ru.yandex.webmaster3.admin.action;

import ru.yandex.webmaster3.admin.security.action.AdminUserIdAware;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

import java.net.URL;

/**
 * @author avhaliullin
 */
public class ListUsersForHostRequest extends AbstractFrontendRequest implements AdminUserIdAware {
    private long adminUserId;
    private URL hostUrl;

    @Override
    public void setAdminUserId(long adminUserId) {
        this.adminUserId = adminUserId;
    }

    @Override
    public long getAdminUserId() {
        return adminUserId;
    }

    public URL getHostUrl() {
        return hostUrl;
    }

    @RequestQueryProperty(required = true)
    public void setHostUrl(URL hostUrl) {
        this.hostUrl = hostUrl;
    }
}
