package ru.yandex.webmaster3.admin.action;

import java.util.List;

import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.data.SimpleHostInfoView;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public class ListUsersForHostResponse implements ActionResponse.NormalResponse {
    private final SimpleHostInfoView hostInfo;
    private final boolean verifiedForMe;
    private final List<HostUserInfo> users;

    public ListUsersForHostResponse(SimpleHostInfoView hostInfo, boolean verifiedForMe, List<HostUserInfo> users) {
        this.hostInfo = hostInfo;
        this.verifiedForMe = verifiedForMe;
        this.users = users;
    }

    @Description("Подтвержден ли хост у пользователя, проассоциированного с yandex-team uid'ом")
    public boolean isVerifiedForMe() {
        return verifiedForMe;
    }

    public List<HostUserInfo> getUsers() {
        return users;
    }

    public SimpleHostInfoView getHostInfo() {
        return hostInfo;
    }

    public static class HostUserInfo {
        public final long userId;
        public final String userLogin;
        public final DateTime verifiedAt;
        public final boolean verified;

        public HostUserInfo(long userId, String userLogin, DateTime verifiedAt, boolean verified) {
            this.userId = userId;
            this.userLogin = userLogin;
            this.verifiedAt = verifiedAt;
            this.verified = verified;
        }
    }
}
