package ru.yandex.webmaster3.admin.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Ручка, которая бросит стандартную ошибку про неавторизованный доступ, если нельзя делать виртуальный логин")
public class VirtualLoginAction extends AdminAction<VirtualLoginRequest, VirtualLoginResponse> {
    public VirtualLoginAction() {
        super(AccessObjectEnum.VIRUAL_LOGIN);
    }

    @Override
    public VirtualLoginResponse process(VirtualLoginRequest request) throws WebmasterException {
        return new VirtualLoginResponse();
    }
}
