package ru.yandex.webmaster3.admin.action.abt;

import lombok.Data;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.abt.dao.AbtExperimentYDao;
import ru.yandex.webmaster3.storage.abt.model.ExperimentScope;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;

/**
 * ishalaru
 * 13.11.2019
 **/
@Slf4j
@WriteAction
@Component("/abt/experiment/update")
@Description("Добавление нового или обновление сущетсвующего эксперемента")
public class UpdateExperimentAction extends AdminAction<UpdateExperimentAction.Request, UpdateExperimentAction.Response> {
    private final AbtExperimentYDao abtExperimentYDao;

    @Autowired
    public UpdateExperimentAction(AbtExperimentYDao abtExperimentYDao) {
        super(AccessObjectEnum.ABT);
        this.abtExperimentYDao = abtExperimentYDao;
    }

    @Override
    public Response process(Request request) {
        abtExperimentYDao.update(request.getExperiment(), request.getDescription(), request.getExperimentScope(), request.isActive());
        return new Response();
    }

    public static class Response implements ActionResponse.NormalResponse {

    }


    @Data
    public static class Request extends AbstractAdminRequest {
        @Setter(onMethod_ = {@Description("Имя эксперемента"), @RequestQueryProperty(required = true)})
        private String experiment;
        @Setter(onMethod_ = {@Description("Скоп эксперемента"), @RequestQueryProperty(required = true)})
        private ExperimentScope experimentScope;
        @Setter(onMethod_ = {@Description("Описание эксперемента"), @RequestQueryProperty(required = false)})
        private String description;
        @Setter(onMethod_ = {@Description("Активен эксперемент или нет"), @RequestQueryProperty(required = false)})
        private boolean active;
    }
}
