package ru.yandex.webmaster3.admin.action.addurl;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.addurl.AddUrlSpamInfo;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

import java.util.Collections;
import java.util.List;

/**
 * Created by Oleg Bazdyrev on 28/09/2017.
 */
@ReadAction
@Description("Вывод спамеров в addurl")
public class ListSpamOwnersAction extends AdminAction<ListSpamOwnersAction.Request, ListSpamOwnersAction.Response> {
    protected ListSpamOwnersAction() {
        super(AccessObjectEnum.TOOLS);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            return new Response(Collections.emptyList(), 0);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Unable to read spam owners list from Ydb",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    public static class Request extends AbstractAdminRequest implements PagerAware {
        private int page = 0;
        private int pageSize = 20;
        private String ownerFilter;

        @Override
        @RequestQueryProperty("0")
        public void setP(int page) {
            this.page = page;
        }

        @Override
        @RequestQueryProperty("20")
        public void setPSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @Description("Фильтр по вхождению подстроки в owner")
        @RequestQueryProperty
        public void setOwnerFilter(String ownerFilter) {
            this.ownerFilter = ownerFilter;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {

        private final List<AddUrlSpamInfo> spamOwners;
        private final long totalSpamOwners;

        public Response(List<AddUrlSpamInfo> spamOwners, long totalSpamOwners) {
            this.spamOwners = spamOwners;
            this.totalSpamOwners = totalSpamOwners;
        }

        public List<AddUrlSpamInfo> getSpamOwners() {
            return spamOwners;
        }

        public long getTotalSpamOwners() {
            return totalSpamOwners;
        }
    }
}
