package ru.yandex.webmaster3.admin.action.addurl;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.addurl.AddUrlSpamInfo;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;

/**
 * Created by Oleg Bazdyrev on 28/09/2017.
 */
@WriteAction
@Description("Разбанить владельца хоста в addurl")
public class UnbanSpamOwnerAction extends AdminAction<UnbanSpamOwnerAction.Request, UnbanSpamOwnerAction.Response> {
    public UnbanSpamOwnerAction() {
        super(AccessObjectEnum.TOOLS);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        throw new WebmasterException("Unban is no longer supported",
                new WebmasterErrorResponse.InternalUnknownErrorResponse(getClass(), "Unban is no longer supported"));
    }

    public static class Request extends AbstractAdminRequest {
        private String punycodeOwner;
        private String comment;

        @RequestQueryProperty(required = true)
        public void setPunycodeOwner(String punycodeOwner) {
            this.punycodeOwner = punycodeOwner;
        }

        @RequestQueryProperty
        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final AddUrlSpamInfo spamOwner;

        public Response(AddUrlSpamInfo spamOwner) {
            this.spamOwner = spamOwner;
        }

        public AddUrlSpamInfo getSpamOwner() {
            return spamOwner;
        }
    }
}
