package ru.yandex.webmaster3.admin.action.events;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.core.events2.HostEventType;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;

import java.net.URL;
import java.util.Set;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class ListHostEventsRequest extends AbstractAdminRequest implements PagerAware {
    private URL hostNameFilter;
    private String requestIdFilter;
    private UUID taskIdFilter;
    private Long userIdFilter;
    private Long adminUserIdFilter;
    private DateTime dateFromFilter;
    private DateTime dateToFilter;
    private Set<HostEventType> eventTypesFilter;
    private int p = 0;
    private int pSize = 20;

    public URL getHostNameFilter() {
        return hostNameFilter;
    }

    @RequestQueryProperty
    public void setHostNameFilter(URL hostNameFilter) {
        this.hostNameFilter = hostNameFilter;
    }

    public String getRequestIdFilter() {
        return requestIdFilter;
    }

    @RequestQueryProperty
    public void setRequestIdFilter(String requestIdFilter) {
        this.requestIdFilter = requestIdFilter;
    }

    public UUID getTaskIdFilter() {
        return taskIdFilter;
    }

    @RequestQueryProperty
    public void setTaskIdFilter(UUID taskIdFilter) {
        this.taskIdFilter = taskIdFilter;
    }

    public Long getUserIdFilter() {
        return userIdFilter;
    }

    @RequestQueryProperty
    public void setUserIdFilter(Long userIdFilter) {
        this.userIdFilter = userIdFilter;
    }

    public Long getAdminUserIdFilter() {
        return adminUserIdFilter;
    }

    @RequestQueryProperty
    public void setAdminUserIdFilter(Long adminUserIdFilter) {
        this.adminUserIdFilter = adminUserIdFilter;
    }

    public DateTime getDateFromFilter() {
        return dateFromFilter;
    }

    @RequestQueryProperty
    public void setDateFromFilter(DateTime dateFromFilter) {
        this.dateFromFilter = dateFromFilter;
    }

    public DateTime getDateToFilter() {
        return dateToFilter;
    }

    @RequestQueryProperty
    public void setDateToFilter(DateTime dateToFilter) {
        this.dateToFilter = dateToFilter;
    }

    public Set<HostEventType> getEventTypesFilter() {
        return eventTypesFilter;
    }

    @RequestQueryProperty
    public void setEventTypesFilter(Set<HostEventType> eventTypesFilter) {
        this.eventTypesFilter = eventTypesFilter;
    }

    public int getP() {
        return p;
    }

    @Override
    public void setP(int p) {
        this.p = p;
    }

    public int getPSize() {
        return pSize;
    }

    @Override
    public void setPSize(int pSize) {
        this.pSize = pSize;
    }
}
