package ru.yandex.webmaster3.admin.action.internal.verification;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.verification.auto.AutoVerificationYDao;

/**
 * @author avhaliullin
 */
@WriteAction
public class AddAutoVerificationAction extends AdminAction<AddAutoVerificationAction.Request,
        AddAutoVerificationAction.Response> {
    @Setter
    private AutoVerificationYDao autoVerificationYDao;
    @Setter
    private boolean enabled;

    protected AddAutoVerificationAction() {
        super(AccessObjectEnum.INTERNAL);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        if (!enabled) {
            throw new RuntimeException("Action is disabled for this environment");
        }
        autoVerificationYDao.insertRecord(request.getToUserId(), request.getHostId());
        return new Response();
    }

    @Getter
    @Setter(onMethod_ = @RequestQueryProperty)
    public static class Request extends AbstractAdminRequest {
        private WebmasterHostId hostId;
        private long toUserId;
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
