package ru.yandex.webmaster3.admin.action.internal.verification;

import lombok.Setter;

import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.verification.auto.AutoVerificationYDao;

/**
 * @author avhaliullin
 */
@WriteAction
public class DeleteAutoVerificationAction extends AdminAction<DeleteAutoVerificationAction.Request,
        DeleteAutoVerificationAction.Response> {
    @Setter
    private AutoVerificationYDao autoVerificationYDao;
    @Setter
    private boolean enabled;

    public DeleteAutoVerificationAction() {
        super(AccessObjectEnum.INTERNAL);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        if (!enabled) {
            throw new RuntimeException("Action is disabled for this environment");
        }
        autoVerificationYDao.deleteRecord(request.getUserId(), request.getHostId());
        return new Response();
    }

    public static class Request extends AbstractAdminRequest {
        private WebmasterHostId hostId;
        private long userId;

        public WebmasterHostId getHostId() {
            return hostId;
        }

        @RequestQueryProperty
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }

        public long getUserId() {
            return userId;
        }

        @RequestQueryProperty
        public void setUserId(long userId) {
            this.userId = userId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
