package ru.yandex.webmaster3.admin.action.mirrors;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;
import ru.yandex.webmaster3.storage.mirrors.service.MainMirrorService;

/**
 * @author tsyplyaev
 */
@ReadAction
@Description("Список запросов на изменение зеркал")
@Category("mirrors")
public class GetMirrorRequestAction extends AdminAction<GetMirrorRequestRequest, GetMirrorRequestResponse> {
    private MainMirrorService mainMirrorService;

    public GetMirrorRequestAction() {
        super(AccessObjectEnum.MIRRORS);
    }

    @Override
    public GetMirrorRequestResponse process(GetMirrorRequestRequest request) throws WebmasterException {
        WebmasterHostId hostId = IdUtils.urlToHostId(request.getHostName());
        MirrorRequest mr = mainMirrorService.getMirrorRequest(hostId, request.getRequestId());
        return new GetMirrorRequestResponse.NormalReponse(mr);
    }

    @Required
    public void setMainMirrorService(MainMirrorService mainMirrorService) {
        this.mainMirrorService = mainMirrorService;
    }
}
