package ru.yandex.webmaster3.admin.action.mirrors;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;

/**
 * @author tsyplyaev
 */
public class ListMirrorRequestsRequest extends AbstractAdminRequest implements PagerAware {
    private int page;
    private int pageSize;
    private String hostName;
    private DateTime fromDate, toDate;

    @Override
    public void setP(int page) {
        this.page = page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPage() {
        return page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public String getHostName() {
        return hostName;
    }

    @RequestQueryProperty(required = true)
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public DateTime getFromDate() {
        return fromDate;
    }

    @RequestQueryProperty
    public void setFromDate(DateTime fromDate) {
        this.fromDate = fromDate;
    }

    public DateTime getToDate() {
        return toDate;
    }

    @RequestQueryProperty
    public void setToDate(DateTime toDate) {
        this.toDate = toDate;
    }
}
