package ru.yandex.webmaster3.admin.action.mirrors;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;

import java.util.List;

/**
 * @author tsyplyaev
 */
public abstract class ListMirrorRequestsResponse implements ActionResponse {
    public static class NormalReponse extends ListMirrorRequestsResponse implements ActionResponse.NormalResponse {
        private final List<MirrorRequest> requests;
        private final long requestCount;

        public NormalReponse(List<MirrorRequest> requests, long requestCount) {
            this.requests = requests;
            this.requestCount = requestCount;
        }

        public List<MirrorRequest> getRequests() {
            return requests;
        }

        public long getRequestCount() {
            return requestCount;
        }
    }
}
