package ru.yandex.webmaster3.admin.action.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.mobile.dao.UserHostMobileAuditRequestsYDao;
import ru.yandex.webmaster3.storage.mobile.data.MobileAuditRequestInfo;
import ru.yandex.webmaster3.storage.mobile.data.MobileAuditRequestState;
import ru.yandex.webmaster3.storage.mobile.data.MobileAuditResult;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Посмотреть статус заявки на проверку страницы")
public class AdminMobileAuditInfoAction extends AdminAction<AdminMobileAuditInfoRequest, AdminMobileAuditInfoResponse> {
    @Autowired
    private UserHostMobileAuditRequestsYDao userHostMobileAuditRequestsYDao;

    public AdminMobileAuditInfoAction() {
        super(AccessObjectEnum.TOOLS);
    }

    @Override
    public AdminMobileAuditInfoResponse process(AdminMobileAuditInfoRequest request) throws WebmasterException {
        try {
            MobileAuditRequestInfo requestInfo = userHostMobileAuditRequestsYDao.getRequest(request.getRequestId());
            if (requestInfo == null) {
                return new AdminMobileAuditInfoResponse.RequestNotFoundResponse();
            }
            if (requestInfo.getState() == MobileAuditRequestState.TASK_FINISHED) {
                switch (requestInfo.getResult().getType()) {
                    case OK:
                        return new AdminMobileAuditInfoResponse.NormalResponse(
                                requestInfo.getCreatedAt(),
                                requestInfo.getState(),
                                requestInfo.getUrl(),
                                requestInfo.getResolution(),
                                asInstanceOf(requestInfo.getResult(), MobileAuditResult.Success.class)
                        );
                    case INTERNAL_ERROR:
                        return new AdminMobileAuditInfoResponse.InternalErrorResponse();
                    case FETCH_FAILED:
                        MobileAuditResult.FetchFailedError fetchFailedError = asInstanceOf(requestInfo.getResult(), MobileAuditResult.FetchFailedError.class);
                        return new AdminMobileAuditInfoResponse.UrlFetchFailedResponse(fetchFailedError.getHttpCode());
                    default:
                        throw new RuntimeException("Unknown result type " + requestInfo.getResult().getType());
                }
            } else {
                return new AdminMobileAuditInfoResponse.NormalResponse(
                        requestInfo.getCreatedAt(),
                        requestInfo.getState(),
                        requestInfo.getUrl(),
                        requestInfo.getResolution(),
                        null
                );
            }
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to read audit result",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    private <T extends MobileAuditResult> T asInstanceOf(MobileAuditResult result, Class<T> clazz) {
        if (!(clazz.isAssignableFrom(result.getClass()))) {
            throw new WebmasterException("Expected " + clazz.getSimpleName() + ", but found " + result.getClass().getSimpleName(),
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(getClass(), null));
        }
        return (T) result;
    }
}
