package ru.yandex.webmaster3.admin.action.mobile;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.mobile.MobileAuditRequestsService;
import ru.yandex.webmaster3.core.mobile.data.ScreenshotResolution;

import java.util.UUID;

/**
 * @author avhaliullin
 */
@Description("Создать заявку на проверку мобилопригодности")
@WriteAction
public class StartAdminMobileAuditAction extends AdminAction<StartAdminMobileAuditRequest, StartAdminMobileAuditResponse> {
    private MobileAuditRequestsService mobileAuditRequestsService;

    public StartAdminMobileAuditAction() {
        super(AccessObjectEnum.TOOLS);
    }

    @Override
    public StartAdminMobileAuditResponse process(StartAdminMobileAuditRequest request) throws WebmasterException {
        WebmasterHostId hostId = IdUtils.urlToHostId(request.getUrl());
        UUID requestId = mobileAuditRequestsService.createRequestNoChecks(request.getAdminUserId(), hostId, request.getUrl(),
                new ScreenshotResolution(request.getWidth(), request.getHeight()));
        return new StartAdminMobileAuditResponse(request.getUrl(), requestId, hostId);
    }

    @Required
    public void setMobileAuditRequestsService(MobileAuditRequestsService mobileAuditRequestsService) {
        this.mobileAuditRequestsService = mobileAuditRequestsService;
    }
}
