package ru.yandex.webmaster3.admin.action.mobile;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class StartAdminMobileAuditResponse implements ActionResponse.NormalResponse {
    private final URL url;
    private final UUID requestId;
    private final WebmasterHostId hostId;

    public StartAdminMobileAuditResponse(URL url, UUID requestId, WebmasterHostId hostId) {
        this.url = url;
        this.requestId = requestId;
        this.hostId = hostId;
    }

    @Description("URL для проверки")
    public URL getUrl() {
        return url;
    }

    @Description("id созданной заявки")
    public UUID getRequestId() {
        return requestId;
    }

    @Description("хост, для которого создана заявка")
    public WebmasterHostId getHostId() {
        return hostId;
    }
}
