package ru.yandex.webmaster3.admin.action.sanctions;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.core.antispam.sanctions.data.AntispamSanctionEnum;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;

import java.net.URL;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class ListSanctionsRequest extends AbstractAdminRequest implements PagerAware {
    private URL hostName;
    private String userLogin;
    private Set<String> sanctions;
    private DateTime fromDate;
    private DateTime toDate;
    private int p = 0;
    private int pSize = 50;

    public URL getHostName() {
        return hostName;
    }

    @Description("Имя хоста для фильтрации")
    @RequestQueryProperty()
    public void setHostName(URL hostName) {
        this.hostName = hostName;
    }

    public String getUserLogin() {
        return userLogin;
    }

    @Description("Логин пользователя для фильтрации")
    @RequestQueryProperty()
    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    @Override
    public void setP(int page) {
        this.p = page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pSize = pageSize;
    }

    public int getP() {
        return p;
    }

    public int getPSize() {
        return pSize;
    }

    public Set<String> getSanctions() {
        return sanctions;
    }

    @Description("Фильтр по типам санкций")
    @RequestQueryProperty
    public void setSanctions(Set<String> sanctions) {
        this.sanctions = sanctions;
    }

    public DateTime getFromDate() {
        return fromDate;
    }

    @Description("Фильтр - начало диапазона дат")
    @RequestQueryProperty
    public void setFromDate(DateTime fromDate) {
        this.fromDate = fromDate;
    }

    public DateTime getToDate() {
        return toDate;
    }

    @Description("Фильтр - конец диапазона дат")
    @RequestQueryProperty
    public void setToDate(DateTime toDate) {
        this.toDate = toDate;
    }
}
