package ru.yandex.webmaster3.admin.action.sanctions;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.List;

/**
 * @author avhaliullin
 */
public abstract class ListSanctionsResponse implements ActionResponse {
    public enum ErrorCodes {
        LIST_SANCTIONS__USER_NOT_FOUND
    }

    public static class NormalReponse extends ListSanctionsResponse implements ActionResponse.NormalResponse {
        private final List<ThreatsRecheckRequestView> requests;
        private final long totalResults;

        public NormalReponse(List<ThreatsRecheckRequestView> requests, long totalResults) {
            this.totalResults = totalResults;
            this.requests = requests;
        }

        public List<ThreatsRecheckRequestView> getRequests() {
            return requests;
        }

        public long getTotalResults() {
            return totalResults;
        }
    }

    public static class UserNotFoundErrorResponse extends ListSanctionsResponse implements ActionResponse.ErrorResponse {
        private final String login;

        public UserNotFoundErrorResponse(String login) {
            this.login = login;
        }

        @Override
        public Enum<?> getCode() {
            return ErrorCodes.LIST_SANCTIONS__USER_NOT_FOUND;
        }

        public String getLogin() {
            return login;
        }

        @Override
        public String getMessage() {
            return "User not found for login " + login;
        }
    }
}
