package ru.yandex.webmaster3.admin.action.sanctions;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.admin.data.SimpleHostInfoView;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class ThreatsRecheckRequestView {
    private final DateTime timeOfRequest;
    private final long userId;
    private final Set<String> sanctions;
    private final SimpleHostInfoView hostInfo;

    public ThreatsRecheckRequestView(WebmasterHostId hostId, DateTime timeOfRequest, long userId, Set<String> sanctions) {
        this.timeOfRequest = timeOfRequest;
        this.userId = userId;
        this.sanctions = sanctions;
        this.hostInfo = new SimpleHostInfoView(hostId);
    }

    public SimpleHostInfoView getHostInfo() {
        return hostInfo;
    }

    public DateTime getTimeOfRequest() {
        return timeOfRequest;
    }

    public long getUserId() {
        return userId;
    }

    public Set<String> getSanctions() {
        return sanctions;
    }

}
