package ru.yandex.webmaster3.admin.action.spamban;

import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.user.dao.SpamBanCountersRedisService;

/**
 * Created by ifilippov5 on 18.01.17.
 */
@ReadAction
@Description("Выводит для каждой минуты, сколько было забанено масок, соответствующих данному правилу. Информация выводится за последние 24 часа.")
public class ShowRuleStatistics extends AdminAction<ShowRuleStatistics.Request, ShowRuleStatistics.Response> {
    @Autowired
    private SpamBanCountersRedisService spamBanCountersRedisService;

    public ShowRuleStatistics() {
        super(AccessObjectEnum.SPAM_BAN);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        long amount = spamBanCountersRedisService.getAmount(request.getRuleId());
        Map<String, Long> counts = spamBanCountersRedisService.getCounts(request.getRuleId());
        Map<String, NavigableMap<Instant, Long>> hitsCounters = spamBanCountersRedisService.getHitsCounters();
        Map<String, NavigableMap<Instant, Long>> masksCounters = spamBanCountersRedisService.getMasksCounters();
        return new Response(amount, counts, hitsCounters, masksCounters);
    }

    public static class Request extends AbstractAdminRequest {
        private UUID ruleId;

        public UUID getRuleId() {
            return ruleId;
        }

        @RequestQueryProperty(required = true)
        public void setRuleId(UUID ruleId) {
            this.ruleId = ruleId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final long amount;
        private final Map<String, Long> counts;
        private final Map<String, NavigableMap<Instant, Long>> hitsCounter;
        private final Map<String, NavigableMap<Instant, Long>> masksCounter;

        Response(long amount, Map<String, Long> counts, Map<String, NavigableMap<Instant, Long>> hitsCounter,
                Map<String, NavigableMap<Instant, Long>> masksCounter)
        {
            this.amount = amount;
            this.counts = counts;
            this.hitsCounter = hitsCounter;
            this.masksCounter = masksCounter;
        }

        public long getAmount() {
            return amount;
        }

        public Map<String, Long> getCounts() {
            return counts;
        }

        public Map<String, NavigableMap<Instant, Long>> getHitsCounter() {
            return hitsCounter;
        }

        public Map<String, NavigableMap<Instant, Long>> getMasksCounter() {
            return masksCounter;
        }
    }
}
