package ru.yandex.webmaster3.admin.action.spamban;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.security.action.AdminUserIdAware;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.user.dao.SpamBanRulesYDao;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

import java.util.UUID;

/**
 * Created by ifilippov5 on 26.12.16.
 */
@WriteAction
@Description("Изменения статуса активности маски.")
@Component("/admin/spamban/rule/update")
public class UpdateActiveStatusAction extends AdminAction<UpdateActiveStatusAction.Request,
        UpdateActiveStatusAction.Response> {
    @Autowired
    private SpamBanRulesYDao spamBanRulesYDao;

    public UpdateActiveStatusAction() {
        super(AccessObjectEnum.SPAM_BAN);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            spamBanRulesYDao.updateRule(request.getRuleId(), request.getActiveStatus(), Instant.now(),
                    request.getAdminUserId());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Unable to update rule",
                    new WebmasterErrorResponse.YDBErrorResponse(this.getClass(), e), e);
        }
        return new Response();
    }

    public static class Request extends AbstractAdminRequest implements AdminUserIdAware {
        private boolean activeStatus;
        private UUID ruleId;
        private long adminUserId;

        public UUID getRuleId() {
            return ruleId;
        }

        @RequestQueryProperty(required = true)
        public void setRuleId(UUID ruleId) {
            this.ruleId = ruleId;
        }

        public boolean getActiveStatus() {
            return activeStatus;
        }

        @RequestQueryProperty(required = true)
        public void setActiveStatus(boolean activeStatus) {
            this.activeStatus = activeStatus;
        }

        @Override
        public long getAdminUserId() {
            return adminUserId;
        }

        @Override
        public void setAdminUserId(long userId) {
            adminUserId = userId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
