package ru.yandex.webmaster3.admin.action.user;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.blackbox.service.BlackboxUsersService;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.security.action.AdminUserIdAware;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * @author aherman
 */
@WriteAction
@Description("Добавление beta-пользователя")
@Component
public class AddBetaUserAction extends AdminAction<AddBetaUserAction.Request, AddBetaUserAction.Response> {
    private final BlackboxUsersService blackboxExternalYandexUsersService;

    @Autowired
    public AddBetaUserAction(@Qualifier("blackboxYandexTeamUsersService") BlackboxUsersService blackboxExternalYandexUsersService) {
        super(AccessObjectEnum.INTERNAL);
        this.blackboxExternalYandexUsersService = blackboxExternalYandexUsersService;
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        return new Response();
    }

    public static class Request extends AbstractFrontendRequest implements AdminUserIdAware {
        private long[] betaUserIds;
        private long adminUserId;

        @RequestPostProperty(required = true)
        public void setBetaUserIds(long[] betaUserIds) {
            this.betaUserIds = betaUserIds;
        }

        @Override
        public long getAdminUserId() {
            return adminUserId;
        }

        @Override
        public void setAdminUserId(long userId) {
            adminUserId = userId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
