package ru.yandex.webmaster3.admin.action.user;

import java.util.Set;

import lombok.Getter;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.user.ServiceAnnouncement;
import ru.yandex.webmaster3.storage.user.service.AnnouncementService;

@ReadAction
@Description("Получить текст по категории и языку")
@Component("/admin/serviceAnnouncement/list")
@Category("notifications")
public class GetServiceAnnouncementAction extends AdminAction<GetServiceAnnouncementAction.GetServiceAnnouncementRequest, GetServiceAnnouncementAction.GetServiceAnnouncementResponse> {

    private AnnouncementService announcementService;

    @Autowired
    public GetServiceAnnouncementAction(AnnouncementService announcementService) {
        super(AccessObjectEnum.NOTIFICATIONS);
        this.announcementService = announcementService;
    }

    @Override
    public GetServiceAnnouncementResponse process(GetServiceAnnouncementRequest request) {
        final Set<ServiceAnnouncement> announcements = announcementService.getServiceAnnouncementByRouteNameRegexp(request.getRouteName(), request.isOnlyEnabled());
        return new GetServiceAnnouncementResponse(announcements);
    }

    @Getter
    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static class GetServiceAnnouncementRequest extends AbstractAdminRequest {
        private String routeName;
        private boolean onlyEnabled;
    }

    @Value
    public static class GetServiceAnnouncementResponse implements ActionResponse.NormalResponse {
        Set<ServiceAnnouncement> serviceAnnouncement;
    }
}
