package ru.yandex.webmaster3.admin.action.user;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.user.BetaUser;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author aherman
 */
@ReadAction
public class ListBetaUsersAction extends AdminAction<ListBetaUsersAction.Request, ListBetaUsersAction.Response> {
    public ListBetaUsersAction() {
        super(AccessObjectEnum.INTERNAL);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
       return new Response(0, Collections.EMPTY_LIST);
    }

    public static class Request extends AbstractAdminRequest implements PagerAware {
        private String loginFilter;
        private int page;
        private int pageSize = 20;

        @Override
        public void setP(int page) {
            this.page = page;
        }

        @Override
        @RequestQueryProperty("20")
        public void setPSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @Description("Фильтр по вхождению подстроки в логинах")
        @RequestQueryProperty()
        public void setLoginFilter(String loginFilter) {
            this.loginFilter = loginFilter;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final int totalBetaUsers;
        private final List<BetaUser> betaUsers;

        public Response(int totalBetaUsers, List<BetaUser> betaUsers) {
            this.totalBetaUsers = totalBetaUsers;
            this.betaUsers = betaUsers;
        }

        public int getTotalBetaUsers() {
            return totalBetaUsers;
        }

        public List<BetaUser> getBetaUsers() {
            return betaUsers;
        }
    }
}
