package ru.yandex.webmaster3.admin.action.user;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.admin.security.action.AdminUserIdAware;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * @author aherman
 */
@WriteAction
public class RemoveBetaUserAction extends AdminAction<RemoveBetaUserAction.Request, RemoveBetaUserAction.Response> {
    public RemoveBetaUserAction() {
        super(AccessObjectEnum.INTERNAL);
    }

    @Override
    public Response process(Request request) throws WebmasterException {
        return new Response();
    }

    public static class Request extends AbstractFrontendRequest implements AdminUserIdAware {
        private long[] betaUserIds;
        private long adminUserId;

        @Override
        public long getAdminUserId() {
            return adminUserId;
        }

        @Override
        public void setAdminUserId(long userId) {
            adminUserId = userId;
        }

        @RequestPostProperty(required = true)
        public void setBetaUserIds(long[] betaUserIds) {
            this.betaUserIds = betaUserIds;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
