package ru.yandex.webmaster3.admin.action.user;

import java.util.Map;

import lombok.Getter;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AbstractAdminRequest;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.user.ServiceAnnouncement;
import ru.yandex.webmaster3.storage.user.service.AnnouncementService;

@WriteAction
@Description("Установить текст по категории и языку")
@Component("/admin/serviceAnnouncement/update")
@Category("notifications")
public class SetServiceAnnouncementAction extends AdminAction<SetServiceAnnouncementAction.SetServiceAnnouncementRequest, SetServiceAnnouncementAction.SetServiceAnnouncementResponse> {
    private AnnouncementService announcementService;

    @Autowired
    public SetServiceAnnouncementAction(AnnouncementService announcementService) {
        super(AccessObjectEnum.NOTIFICATIONS);
        this.announcementService = announcementService;
    }

    @Override
    public SetServiceAnnouncementResponse process(SetServiceAnnouncementRequest request) {
        Map<LanguageEnum, String> texts = Map.of(LanguageEnum.RU, request.getTextRu(), LanguageEnum.EN, request.getTextEn());
        announcementService.setServiceAnnouncement(request.getRouteNameRegexp(), texts, request.isEnabled(), request.type);
        return new SetServiceAnnouncementResponse();
    }

    @Getter
    @Setter(onMethod_ = @RequestQueryProperty)
    public static class SetServiceAnnouncementRequest extends AbstractAdminRequest {
        @Setter(onMethod_ = @RequestQueryProperty(required = true))
        private String routeNameRegexp;
        private String textRu = "";
        private String textEn = "";
        private boolean enabled = false;
        private ServiceAnnouncement.Type type ;
    }

    @Value
    public static class SetServiceAnnouncementResponse implements ActionResponse.NormalResponse {
    }
}
