package ru.yandex.webmaster3.admin.action.util;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * Created by ifilippov5 on 22.06.17.
 */
public abstract class AdminServerResponseUtilResponse implements ActionResponse {
    public static class NormalResponse extends AdminServerResponseUtilResponse implements ActionResponse.NormalResponse {
        private final HttpResponsePart httpResponsePart;
        private final String sitaRequestJson;
        private final String sitaResponseJson;

        public NormalResponse(HttpResponsePart httpResponsePart, String sitaRequestJson, String sitaResponseJson) {
            this.httpResponsePart = httpResponsePart;
            this.sitaRequestJson = sitaRequestJson;
            this.sitaResponseJson = sitaResponseJson;
        }

        @JsonUnwrapped
        public HttpResponsePart getHttpResponsePart() {
            return httpResponsePart;
        }

        public String getSitaRequestJson() {
            return sitaRequestJson;
        }

        public String getSitaResponseJson() {
            return sitaResponseJson;
        }
    }

    public static enum ErrorType {
        SERVER_RESPONSE_TOOL__UNABLE_TO_DOWNLOAD_CONTENT,
        SERVER_RESPONSE_TOOL__URL_IS_DISALLOWED_IN_ROBOTS_TXT,
    }

    private static abstract class BaseErrorResponse extends AdminServerResponseUtilResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        public BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class UrlIsDisallowedInRobotsTxt extends BaseErrorResponse {
        public UrlIsDisallowedInRobotsTxt(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return ErrorType.SERVER_RESPONSE_TOOL__URL_IS_DISALLOWED_IN_ROBOTS_TXT;}
        @Override public String getMessage() {return "Url is disallowed in robots.txt";}
    }

    public static class UnableToDownloadContentResponse extends BaseErrorResponse {
        public UnableToDownloadContentResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return ErrorType.SERVER_RESPONSE_TOOL__UNABLE_TO_DOWNLOAD_CONTENT;}
        @Override public String getMessage() {return "Unable to download content";}
    }
}
