package ru.yandex.webmaster3.admin.data;

import ru.yandex.webmaster3.storage.admin.security.AccessActionEnum;
import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.storage.admin.security.Permission;

/**
 * @author avhaliullin
 */
public enum AdminConsoleSectionEnum {
    VIRTUAL_LOGIN(new Permission(AccessActionEnum.READ, AccessObjectEnum.VIRUAL_LOGIN)),
    HOSTS(new Permission(AccessActionEnum.READ, AccessObjectEnum.USERS_HOSTS)),
    DISPLAY_NAME_MODERATION(new Permission(AccessActionEnum.READ, AccessObjectEnum.DISPLAY_NAME_MODERATION)),
    HOST_REGION_MODERATION(new Permission(AccessActionEnum.READ, AccessObjectEnum.HOST_REGION_MODERATION));

    private final Permission relatedPermission;

    AdminConsoleSectionEnum(Permission relatedPermission) {
        this.relatedPermission = relatedPermission;
    }

    public Permission getRelatedPermission() {
        return relatedPermission;
    }
}
