package ru.yandex.webmaster3.admin.data;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class ModeratedVerificationRecord {
    private final UUID verificationTaskId;
    private final long adminUserId;
    private final String comment;
    private final long userId;
    private final WebmasterHostId hostId;

    public ModeratedVerificationRecord(UUID verificationTaskId, long adminUserId, String comment, long userId, WebmasterHostId hostId) {
        this.verificationTaskId = verificationTaskId;
        this.adminUserId = adminUserId;
        this.comment = comment;
        this.userId = userId;
        this.hostId = hostId;
    }

    public UUID getVerificationTaskId() {
        return verificationTaskId;
    }

    public long getAdminUserId() {
        return adminUserId;
    }

    public String getComment() {
        return comment;
    }

    public long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }
}
