package ru.yandex.webmaster3.admin.security;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * @author avhaliullin
 */
public interface AdminRequestFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        ADMIN_USER__UNAUTHORIZED_ACCESS,
        ADMIN_USER__NOT_LOGGED_IN,
    }

    @Description("Недостаточно прав для совершения действия")
    class NotAuthorized extends WebmasterErrorResponse implements AdminRequestFilterResponse {
        public NotAuthorized(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return Code.ADMIN_USER__UNAUTHORIZED_ACCESS;}
        @Override public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.ADMIN_USER;}
        @Override public String getMessage() {return "User hasn't got enough permissions";}
    }

    @Description("Пользователь не авторизован")
    class NotLoggedIn extends WebmasterErrorResponse implements AdminRequestFilterResponse {
        public NotLoggedIn(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return Code.ADMIN_USER__NOT_LOGGED_IN;}
        @Override public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.ADMIN_USER;}
        @Override public String getMessage() {return "User should be logged in";}
    }

}
