package ru.yandex.webmaster3.admin.security;

import ru.yandex.webmaster3.storage.admin.security.Role;

/**
 * @author avhaliullin
 */
public abstract class IDMRole {
    private IDMRole() {
    }

    public static final String HOST_OWNER_ROLE_ID = "host_owner";

    public abstract String getId();

    public abstract String getRequestedLogin();

    public static class SimpleRole extends IDMRole {
        private final Role role;
        private final String requestedLogin;

        public SimpleRole(Role role, String requestedLogin) {
            this.role = role;
            this.requestedLogin = requestedLogin;
        }

        public Role getRole() {
            return role;
        }

        @Override
        public String getId() {
            return role.getId();
        }

        @Override
        public String getRequestedLogin() {
            return requestedLogin;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            SimpleRole idmRole = (SimpleRole) o;

            if (role != idmRole.role) {
                return false;
            }
            return requestedLogin.equals(idmRole.requestedLogin);

        }

        @Override
        public int hashCode() {
            int result = role.hashCode();
            result = 31 * result + requestedLogin.hashCode();
            return result;
        }
    }

    public static class HostOwnerRole extends IDMRole {
        private final String requestedLogin;
        private final String requestedHost;

        public HostOwnerRole(String requestedLogin, String requestedHost) {
            this.requestedLogin = requestedLogin;
            this.requestedHost = requestedHost;
        }

        @Override
        public String getId() {
            return HOST_OWNER_ROLE_ID;
        }

        @Override
        public String getRequestedLogin() {
            return requestedLogin;
        }

        public String getRequestedHost() {
            return requestedHost;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            HostOwnerRole that = (HostOwnerRole) o;

            if (!requestedLogin.equals(that.requestedLogin)) {
                return false;
            }
            return requestedHost.equals(that.requestedHost);

        }

        @Override
        public int hashCode() {
            int result = requestedLogin.hashCode();
            result = 31 * result + requestedHost.hashCode();
            return result;
        }
    }
}
