package ru.yandex.webmaster3.admin.security;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.admin.security.action.AdminAction;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.InternalAction;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.http.request.RequestContext;

/**
 * @author avhaliullin
 */
@Description("Действие не доступно под виртуальным логином, всегда возвращает ошибку INTERNAL__READ_ONLY_MODE")
public class VirtualLoginWriteActionFilter implements RequestFilter<ActionRequest, VirtualLoginWriteActionFilterResponse> {
    @Override
    public boolean isApplicable(Action action) {
        return !action.getClass().isAnnotationPresent(InternalAction.class) &&
                action.getClass().isAnnotationPresent(WriteAction.class) &&
                !AdminAction.class.isAssignableFrom(action.getClass());
    }

    @Override
    public VirtualLoginWriteActionFilterResponse beforeRequest(RequestContext ctx, ActionRequest req) {
        return new VirtualLoginWriteActionFilterResponse.ReadOnlyMode(getClass());
    }
}
