package ru.yandex.webmaster3.admin.security;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * @author avhaliullin
 */
public interface VirtualLoginWriteActionFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        INTERNAL__READ_ONLY_MODE,
    }

    @Description("Запись недоступна под виртуальным логином")
    class ReadOnlyMode extends WebmasterErrorResponse implements VirtualLoginWriteActionFilterResponse {
        public ReadOnlyMode(Class<?> clazz) {super(clazz);}

        @Override
        public Enum<?> getCode() {return Code.INTERNAL__READ_ONLY_MODE;}

        @Override
        public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.INTERNAL;}

        @Override
        public String getMessage() {return "Read only mode enabled";}
    }

}
