package ru.yandex.webmaster3.admin.security.action;

import org.jetbrains.annotations.Nullable;

import ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;

/**
 * @author avhaliullin
 */
public abstract class AdminAction<
        Request extends ActionRequest & RequestIdAware & AdminUserIdAware,
        Response extends ActionResponse
        > extends Action<Request, Response> {
    @Nullable
    private final AccessObjectEnum accessObject;

    protected AdminAction(@Nullable AccessObjectEnum accessObject) {
        this.accessObject = accessObject;
    }

    @Nullable
    public AccessObjectEnum getAccessObject() {
        return accessObject;
    }
}
