CREATE TABLE `dic_host_display_name_moderation_status` (
  id   INT PRIMARY KEY,
  name VARCHAR(128) NOT NULL UNIQUE KEY
)
  ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

INSERT INTO dic_host_display_name_moderation_status (id, name) VALUES (0, 'ACCEPTED'), (1, 'REFUSED');

CREATE TABLE `host_display_name_moderation_history` (
  `host_id`      VARCHAR(512)
                 CHARACTER SET latin1 NOT NULL,
  `request_id`   BINARY(16)           NOT NULL,
  `moderator_id` BIGINT(20)           NOT NULL,
  `moderated_at` DATETIME             NOT NULL,
  `status`       INT                  NOT NULL,
  `display_name` VARCHAR(512)
                 CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (host_id, request_id),
  KEY (status, moderator_id, moderated_at),
  KEY (moderator_id, moderated_at),
  KEY (status, moderated_at),
  KEY (moderated_at),
  CONSTRAINT fk_host_display_name_moderation_history_status FOREIGN KEY (status) REFERENCES dic_host_display_name_moderation_status (id)
)
  ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

CREATE TABLE dic_host_region_moderation_status (
  id   INT PRIMARY KEY,
  name VARCHAR(128) NOT NULL UNIQUE KEY
)
  ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

INSERT INTO dic_host_region_moderation_status (id, name) VALUES (0, 'ACCEPTED'), (1, 'REFUSED'), (2, 'OVERRIDDEN');

CREATE TABLE host_region_moderation_history (
  host_id      VARCHAR(512)
               CHARACTER SET latin1 NOT NULL,
  request_id   BINARY(16)           NOT NULL,
  moderator_id BIGINT(20)           NOT NULL,
  moderated_at DATETIME             NOT NULL,
  status       INT                  NOT NULL,
  region_id    INT                  NOT NULL,
  evidence_url VARCHAR(1024)        DEFAULT NULL,
  PRIMARY KEY (host_id, request_id),
  KEY (status, moderator_id, moderated_at),
  KEY (moderator_id, moderated_at),
  KEY (status, moderated_at),
  KEY (moderated_at),
  CONSTRAINT fk_host_region_moderation_history_status FOREIGN KEY (status) REFERENCES dic_host_region_moderation_status (id)
);