package ru.yandex.webmaster3.api.addurl.action;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.DailyQuotaUtil;
import ru.yandex.webmaster3.storage.addurl.AddUrlRequestsService;

/**
 * @author leonidrom
 */
@Description("Возвращает текущую квоту на переобход")
@Category("addurl")
@Component
public class GetRecrawlQuotaAction extends AbstractApiAction<GetRecrawlQuotaRequest, GetRecrawlQuotaResponse> {
    private AddUrlRequestsService addUrlRequestsService;

    public GetRecrawlQuotaAction() {
        super(Permission.COMMON);
    }

    @Override
    public GetRecrawlQuotaResponse process(GetRecrawlQuotaRequest request) {
        DailyQuotaUtil.QuotaUsage currentQuota = addUrlRequestsService.getQuotaUsage(request.getHostId(), DateTime.now());

        return new GetRecrawlQuotaResponse(currentQuota.getTodayQuota(), currentQuota.getQuotaRemain());
    }

    @Required
    public void setAddUrlRequestsService(AddUrlRequestsService addUrlRequestsService) {
        this.addUrlRequestsService = addUrlRequestsService;
    }
}
